/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.sas;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.sas.ClientLocation;
import com.ibm.hwmca.fw.rcs.sas.CompanyIdentifier;
import com.ibm.hwmca.fw.rcs.sas.LicenseAcceptance;
import com.ibm.hwmca.fw.rcs.sas.PSeriesEnrollment;
import com.ibm.hwmca.fw.rcs.sas.RegisterUsers;
import com.ibm.hwmca.fw.rcs.sas.SystemIdentifier;
import com.ibm.hwmca.fw.rcs.sas.XSeriesEnrollment;
import com.ibm.hwmca.fw.rcs.sas.ZSeriesEnrollment;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;

public class EnrollmentRequestBody
extends RsfRequestBody {
    public static final String CREDENTIAL_RESULT = "Credential Result";
    SystemIdentifier systemIdentifier;
    ClientLocation clientLocation;
    CompanyIdentifier companyIdentifier;
    LicenseAcceptance licenseAcceptance;
    RegisterUsers registerUsers;
    XSeriesEnrollment xseriesEnrollment;
    ZSeriesEnrollment zseriesEnrollment;
    PSeriesEnrollment pseriesEnrollment;

    public EnrollmentRequestBody(SystemIdentifier systemIdentifier, ClientLocation clientLocation, CompanyIdentifier companyIdentifier, LicenseAcceptance licenseAcceptance, RegisterUsers registerUsers, XSeriesEnrollment xseriesEnrollment, ZSeriesEnrollment zseriesEnrollment, PSeriesEnrollment pseriesEnrollment) {
        if (systemIdentifier == null || clientLocation == null || companyIdentifier == null) {
            throw new IllegalArgumentException("EnrollmentRequestBody systemIdentifier, clientLocation, or companyIdentifier is null");
        }
        this.systemIdentifier = systemIdentifier;
        this.clientLocation = clientLocation;
        this.companyIdentifier = companyIdentifier;
        this.licenseAcceptance = licenseAcceptance;
        this.registerUsers = registerUsers;
        this.xseriesEnrollment = xseriesEnrollment;
        this.zseriesEnrollment = zseriesEnrollment;
        this.pseriesEnrollment = pseriesEnrollment;
    }

    public EnrollmentRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.systemIdentifier = ((Persistent)data).systemIdentifier;
        this.clientLocation = ((Persistent)data).clientLocation;
        this.companyIdentifier = ((Persistent)data).companyIdentifier;
        this.licenseAcceptance = ((Persistent)data).licenseAcceptance;
        this.registerUsers = ((Persistent)data).registerUsers;
        this.xseriesEnrollment = ((Persistent)data).xseriesEnrollment;
        this.zseriesEnrollment = ((Persistent)data).zseriesEnrollment;
        this.pseriesEnrollment = ((Persistent)data).pseriesEnrollment;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.systemIdentifier = this.systemIdentifier;
        result.clientLocation = this.clientLocation;
        result.companyIdentifier = this.companyIdentifier;
        result.licenseAcceptance = this.licenseAcceptance;
        result.registerUsers = this.registerUsers;
        result.xseriesEnrollment = this.xseriesEnrollment;
        result.zseriesEnrollment = this.zseriesEnrollment;
        result.pseriesEnrollment = this.pseriesEnrollment;
        return result;
    }

    public boolean isValid() {
        return super.isValid() && this.systemIdentifier != null && this.clientLocation != null && this.companyIdentifier != null;
    }

    public SystemIdentifier getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public ClientLocation getClientLocation() {
        return this.clientLocation;
    }

    public CompanyIdentifier getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public LicenseAcceptance getLicenseAcceptance() {
        return this.licenseAcceptance;
    }

    public RegisterUsers getRegisterUsers() {
        return this.registerUsers;
    }

    public XSeriesEnrollment getXSeriesEnrollment() {
        return this.xseriesEnrollment;
    }

    public ZSeriesEnrollment getZSeriesEnrollment() {
        return this.zseriesEnrollment;
    }

    public PSeriesEnrollment getPSeriesEnrollment() {
        return this.pseriesEnrollment;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<enrollment>");
        buffer.append(this.systemIdentifier.toXml());
        buffer.append(this.clientLocation.toXml());
        buffer.append(this.companyIdentifier.toXml());
        if (this.licenseAcceptance != null) {
            buffer.append(this.licenseAcceptance.toXml());
        }
        if (this.registerUsers != null) {
            buffer.append(this.registerUsers.toXml());
        }
        if (this.xseriesEnrollment != null) {
            buffer.append(this.xseriesEnrollment.toXml());
        }
        if (this.zseriesEnrollment != null) {
            buffer.append(this.zseriesEnrollment.toXml());
        }
        if (this.pseriesEnrollment != null) {
            buffer.append(this.pseriesEnrollment.toXml());
        }
        buffer.append("</enrollment>");
        return buffer.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        SystemIdentifier systemIdentifier;
        ClientLocation clientLocation;
        CompanyIdentifier companyIdentifier;
        LicenseAcceptance licenseAcceptance;
        RegisterUsers registerUsers;
        XSeriesEnrollment xseriesEnrollment;
        ZSeriesEnrollment zseriesEnrollment;
        PSeriesEnrollment pseriesEnrollment;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

